/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class CommandScalingHealth
implements ICommand {
    public static final String NUMFORMAT = "%.2f";

    public int compareTo(ICommand arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "scalinghealth";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + " <difficulty|health> <value> [player]";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            return;
        }
        String command = args[0];
        double value = -1.0;
        EntityPlayerMP targetPlayer = null;
        if (args.length > 1) {
            try {
                value = Double.parseDouble(args[1]);
            }
            catch (Exception ex) {
                this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
                return;
            }
        }
        if (args.length > 2) {
            String name = args[2];
            targetPlayer = server.func_184103_al().func_152612_a(name);
            if (targetPlayer == null) {
                this.tell(sender, "playerNotFound", true, name);
                return;
            }
        }
        if (command.equals("difficulty")) {
            this.executeDifficulty(server, sender, value, (EntityPlayer)targetPlayer);
        } else if (command.equals("health")) {
            this.executeHealth(server, sender, value, (EntityPlayer)targetPlayer);
        }
    }

    private void executeDifficulty(MinecraftServer server, ICommandSender sender, double value, EntityPlayer targetPlayer) {
        SHPlayerDataHandler.PlayerData data;
        if (targetPlayer == null) {
            targetPlayer = (EntityPlayer)sender;
        }
        if ((data = SHPlayerDataHandler.get(targetPlayer)) == null) {
            this.tell(sender, "Player data is null!", false, new Object[0]);
            return;
        }
        if (value < 0.0) {
            double current = data.getDifficulty();
            String strCurrent = String.format(NUMFORMAT, current);
            String strMax = String.format(NUMFORMAT, Float.valueOf(ConfigScalingHealth.DIFFICULTY_MAX));
            this.tell(sender, "showDifficulty", true, targetPlayer.func_70005_c_(), strCurrent, strMax);
        } else {
            if (value < 0.0 || value > (double)ConfigScalingHealth.DIFFICULTY_MAX) {
                this.tell(sender, "outOfBounds", true, String.format(NUMFORMAT, Float.valueOf(0.0f)), String.format(NUMFORMAT, Float.valueOf(ConfigScalingHealth.DIFFICULTY_MAX)));
                return;
            }
            data.setDifficulty(value);
            this.tell(sender, "setDifficulty", true, targetPlayer.func_70005_c_(), String.format(NUMFORMAT, value));
        }
    }

    private void executeHealth(MinecraftServer server, ICommandSender sender, double value, EntityPlayer targetPlayer) {
        SHPlayerDataHandler.PlayerData data;
        if (targetPlayer == null) {
            targetPlayer = (EntityPlayer)sender;
        }
        if ((data = SHPlayerDataHandler.get(targetPlayer)) == null) {
            this.tell(sender, "Player data is null!", false, new Object[0]);
            return;
        }
        if (value < 0.0) {
            float current = targetPlayer.func_110143_aJ();
            float max = targetPlayer.func_110138_aP();
            String strCurrent = String.format(NUMFORMAT, Float.valueOf(current));
            String strMax = String.format(NUMFORMAT, Float.valueOf(max));
            this.tell(sender, "showHealth", true, targetPlayer.func_70005_c_(), strCurrent, strMax);
        } else {
            int max = ConfigScalingHealth.PLAYER_HEALTH_MAX;
            int n = max = max <= 0 ? Integer.MAX_VALUE : max;
            if (value < 2.0 || value > (double)max) {
                this.tell(sender, "outOfBounds", true, 2, max);
                return;
            }
            float currentHealth = targetPlayer.func_110143_aJ();
            float toHeal = (float)(value - (double)currentHealth);
            data.setMaxHealth((float)value);
            if (toHeal > 0.0f) {
                targetPlayer.func_70691_i(toHeal);
            }
            this.tell(sender, "setHealth", true, targetPlayer.func_70005_c_(), value);
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return server.func_71262_S() && !(sender instanceof EntityPlayer) || server.func_71264_H() && server.field_71305_c[0].func_72912_H().func_76086_u() || server.func_184103_al().func_152603_m().func_152700_a(sender.func_70005_c_()) != null;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return Lists.newArrayList((Object[])new String[]{"difficulty", "health"});
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    private void tell(ICommandSender sender, String key, boolean fromLocalizationFile, Object ... args) {
        String value = fromLocalizationFile ? ScalingHealth.localizationHelper.getLocalizedString("command." + key, args) : key;
        sender.func_145747_a((ITextComponent)new TextComponentString(value));
    }
}

