/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.scalinghealth.client.ClientTickHandler;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;

public class HeartDisplayHandler
extends Gui {
    public static final ResourceLocation TEXTURE = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    long lastSystemTime = 0L;
    long healthUpdateCounter = 0L;
    int updateCounter = 0;
    int playerHealth = 0;
    int lastPlayerHealth = 0;
    Random rand = new Random();

    @SubscribeEvent
    public void onHealthBar(RenderGameOverlayEvent.Pre event) {
        int i;
        if (!ConfigScalingHealth.CHANGE_HEART_RENDERING || event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        event.setCanceled(true);
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        boolean hardcoreMode = mc.field_71441_e.func_72912_H().func_76093_s();
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        GlStateManager.func_179147_l();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean highlight = player.field_70172_ad / 3 % 2 == 1;
        this.updateCounter = ClientTickHandler.ticksInGame;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 10;
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = Math.min((float)attrMaxHealth.func_111126_e(), 20.0f);
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(this.updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = this.updateCounter % 25;
        }
        int TOP = 9 * (hardcoreMode ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i2 = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i2 >= 0; --i2) {
            int row = MathHelper.func_76123_f((float)((float)(i2 + 1) / 10.0f)) - 1;
            int x = left + i2 % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i2 == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i2 * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i2 * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                if (i2 * 2 + 1 < health) {
                    this.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i2 * 2 + 1 < health) {
                this.func_73729_b(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i2 * 2 + 1 != health) continue;
            this.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
        int potionOffset = player.func_70644_a(MobEffects.field_82731_v) ? 18 : (player.func_70644_a(MobEffects.field_76436_u) ? 9 : 0) + (hardcoreMode ? 27 : 0);
        mc.field_71446_o.func_110577_a(TEXTURE);
        health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        for (i = 0; i < health / 20; ++i) {
            int renderHearts = Math.min((health - 20 * (i + 1)) / 2, 10);
            int rowColor = this.getColorForRow(i);
            for (int j = 0; j < renderHearts; ++j) {
                int y = 0 + (j == regen ? -2 : 0);
                this.drawTexturedModalRect(left + 8 * j, top + y, 0, potionOffset, 9, 9, rowColor);
            }
            if (health % 2 != 1 || renderHearts >= 10) continue;
            this.drawTexturedModalRect(left + 8 * renderHearts, top, 9, potionOffset, 9, 9, rowColor);
        }
        for (i = 0; i < 10 && i < health / 2; ++i) {
            this.drawTexturedModalRect(left + 8 * i, top, 17, potionOffset, 9, 9, 0xFFFFFF);
        }
        GlStateManager.func_179084_k();
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    protected void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        this.func_73729_b(x, y, textureX, textureY, width, height);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getColorForRow(int row) {
        return ConfigScalingHealth.HEART_COLORS[row % ConfigScalingHealth.HEART_COLORS.length];
    }
}

