/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.silentchaos512.lib.registry.IHasSubtypes;
import net.silentchaos512.lib.registry.IRegistryObject;

public class BlockContainerSL
extends BlockContainer
implements IRegistryObject,
IHasSubtypes {
    protected final int subBlockCount;
    protected boolean hasSubtypes = false;
    protected String blockName;
    protected String modId;

    protected BlockContainerSL(int subBlockCount, String modId, String name, Material material) {
        super(material);
        this.subBlockCount = subBlockCount;
        this.modId = modId.toLowerCase();
        this.func_149663_c(name);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    @Override
    public boolean hasSubtypes() {
        return this.subBlockCount > 1;
    }

    @Override
    public void addRecipes() {
    }

    @Override
    public void addOreDict() {
    }

    @Override
    public String getName() {
        return this.blockName;
    }

    @Override
    public String getFullName() {
        return this.modId + ":" + this.getName();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public List<ModelResourceLocation> getVariants() {
        if (this.hasSubtypes) {
            ArrayList models = Lists.newArrayList();
            for (int i = 0; i < this.subBlockCount; ++i) {
                models.add(new ModelResourceLocation(this.getFullName() + i, "inventory"));
            }
            return models;
        }
        return Lists.newArrayList((Object[])new ModelResourceLocation[]{new ModelResourceLocation(this.getFullName(), "inventory")});
    }

    @Override
    public boolean registerModels() {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.hasSubtypes) {
            for (int i = 0; i < this.subBlockCount; ++i) {
                list.add((Object)new ItemStack(item, 1, i));
            }
        } else {
            list.add((Object)new ItemStack(item));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.hasSubtypes ? this.func_176201_c(state) : 0;
    }

    public String func_149739_a() {
        return "tile." + this.blockName;
    }

    public Block func_149663_c(String name) {
        this.blockName = name;
        return super.func_149663_c(name);
    }
}

